<?php
/**
 * Uninstall script for Floyi Connect.
 *
 * Removes all plugin data when the plugin is deleted.
 *
 * @package Floyi_Connect
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

// Delete options
$options = array(
    'floyi_site_id',
    'floyi_site_token',
    'floyi_webhook_secret',
    'floyi_connection_status',
    'floyi_connected_at',
    'floyi_app_url',
    'floyi_last_sync',
    'floyi_connection_code',
    'floyi_connection_code_expiry',
);

foreach ($options as $option) {
    delete_option($option);
}

// Drop custom tables
$tables = array(
    $wpdb->prefix . 'floyi_nonce_cache',
    $wpdb->prefix . 'floyi_webhook_queue',
);

foreach ($tables as $table) {
    $wpdb->query("DROP TABLE IF EXISTS $table");
}

// Delete post meta
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key = '_floyi_article_id'");

// Clear scheduled hooks
wp_clear_scheduled_hook('floyi_process_webhook_queue');

// Clear any transients
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_floyi_%'");
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_floyi_%'");
